/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class IcyModifier
extends Modifier
implements ProjectileHitModifierHook {
    public static boolean canEffect(LivingEntity living) {
        return living.f_19797_ % 40 == 0;
    }

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.PROJECTILE_HIT);
    }

    public static float calcAmount(LivingEntity entity) {
        BlockPos pos = entity.m_20097_();
        Level world = entity.m_20193_();
        float temp = ((Biome)world.m_204166_(pos).m_203334_()).m_47554_();
        if (temp == 0.15f) {
            return 0.0f;
        }
        return (temp > 0.15f ? 6.5f : 6.15f) * (0.15f - temp);
    }

    public void onInventoryTick(IToolStackView tool, int level, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (IcyModifier.canEffect(holder) && !tool.isBroken()) {
            int amount = (int)IcyModifier.calcAmount(holder);
            if (amount < 0) {
                ToolDamageUtil.damage((IToolStackView)tool, (int)(-amount), (LivingEntity)holder, (ItemStack)stack);
            } else {
                ToolDamageUtil.repair((IToolStackView)tool, (int)amount);
            }
        }
    }

    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        LivingEntity target = context.getLivingTarget();
        if (target != null) {
            target.m_20095_();
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 0));
            target.m_146917_(3);
        }
        return 0;
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        AbstractArrow arrow;
        if (target != null && attacker != null && (!(projectile instanceof AbstractArrow) || (arrow = (AbstractArrow)projectile).m_36792_())) {
            target.m_20095_();
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 0));
            target.m_146917_(3);
        }
        return false;
    }
}

